/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images.image;

import com.andavin.images.MapHelper;
import com.andavin.images.image.CustomImage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public class CustomImageSection
implements Serializable {
    private static final long serialVersionUID = 572225588300845874L;
    public static final int DEFAULT_STARTING_ID = 0x1FFFFFFF;
    private static final AtomicInteger ID_COUNTER = new AtomicInteger(0x1FFFFFFF);
    private final byte[] pixels;
    private final BlockFace direction;
    private final int rotation;
    private transient Location location;
    private transient int frameId;
    private transient int mapId;
    transient Set<UUID> shown = new HashSet<UUID>();

    CustomImageSection(Location location, BlockFace direction, int rotation, BufferedImage image) {
        this.rotation = rotation;
        this.frameId = ID_COUNTER.getAndIncrement();
        this.mapId = MapHelper.getNextMapId(location.getWorld());
        this.location = location;
        this.direction = direction;
        this.pixels = MapHelper.getPixels(image);
    }

    public int getFrameId() {
        return this.frameId;
    }

    public int getMapId() {
        return this.mapId;
    }

    public Location getLocation() {
        return this.location;
    }

    public BlockFace getDirection() {
        return this.direction;
    }

    public int getRotation() {
        return this.rotation;
    }

    public byte[] getPixels() {
        return (byte[])this.pixels.clone();
    }

    public void show(Player player) {
        if (this.shown.add(player.getUniqueId())) {
            MapHelper.createMap(player, this.frameId, this.mapId, this.location, this.direction, this.rotation, this.pixels);
        }
    }

    public void hide(Player player) {
        if (this.shown.remove(player.getUniqueId())) {
            MapHelper.destroyMaps(player, this.frameId);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        CustomImage.writeLocation(out, this.location);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.location = CustomImage.readLocation(in);
        this.frameId = ID_COUNTER.getAndIncrement();
        this.mapId = MapHelper.getNextMapId(this.location.getWorld());
        this.shown = new HashSet<UUID>();
    }
}

